package io.fabric8.kubernetes.api.model.policy.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EvictionBuilder extends EvictionFluentImpl<EvictionBuilder> implements VisitableBuilder<Eviction,io.fabric8.kubernetes.api.model.policy.v1.EvictionBuilder>{
  public EvictionBuilder() {
    this(false);
  }
  public EvictionBuilder(Boolean validationEnabled) {
    this(new Eviction(), validationEnabled);
  }
  public EvictionBuilder(io.fabric8.kubernetes.api.model.policy.v1.EvictionFluent<?> fluent) {
    this(fluent, false);
  }
  public EvictionBuilder(io.fabric8.kubernetes.api.model.policy.v1.EvictionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Eviction(), validationEnabled);
  }
  public EvictionBuilder(io.fabric8.kubernetes.api.model.policy.v1.EvictionFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1.Eviction instance) {
    this(fluent, instance, false);
  }
  public EvictionBuilder(io.fabric8.kubernetes.api.model.policy.v1.EvictionFluent<?> fluent,io.fabric8.kubernetes.api.model.policy.v1.Eviction instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withDeleteOptions(instance.getDeleteOptions()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public EvictionBuilder(io.fabric8.kubernetes.api.model.policy.v1.Eviction instance) {
    this(instance,false);
  }
  public EvictionBuilder(io.fabric8.kubernetes.api.model.policy.v1.Eviction instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withDeleteOptions(instance.getDeleteOptions()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.policy.v1.EvictionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.policy.v1.Eviction build() {
    Eviction buildable = new Eviction(fluent.getApiVersion(),fluent.getDeleteOptions(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}