package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeClassStrategyOptionsBuilder extends RuntimeClassStrategyOptionsFluentImpl<RuntimeClassStrategyOptionsBuilder> implements VisitableBuilder<RuntimeClassStrategyOptions,RuntimeClassStrategyOptionsBuilder> {

    RuntimeClassStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public RuntimeClassStrategyOptionsBuilder() {
        this(true);
    }

    public RuntimeClassStrategyOptionsBuilder(Boolean validationEnabled) {
        this(new RuntimeClassStrategyOptions(), validationEnabled);
    }

    public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent) {
        this(fluent, true);
    }

    public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RuntimeClassStrategyOptions(), validationEnabled);
    }

    public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent,RuntimeClassStrategyOptions instance) {
        this(fluent, instance, true);
    }

    public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptionsFluent<?> fluent,RuntimeClassStrategyOptions instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames()); 
        fluent.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptions instance) {
        this(instance,true);
    }

    public RuntimeClassStrategyOptionsBuilder(RuntimeClassStrategyOptions instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withAllowedRuntimeClassNames(instance.getAllowedRuntimeClassNames()); 
        this.withDefaultRuntimeClassName(instance.getDefaultRuntimeClassName()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeClassStrategyOptions build() {
        RuntimeClassStrategyOptions buildable = new RuntimeClassStrategyOptions(fluent.getAllowedRuntimeClassNames(),fluent.getDefaultRuntimeClassName());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuntimeClassStrategyOptionsBuilder that = (RuntimeClassStrategyOptionsBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
