package io.fabric8.kubernetes.api.model.policy;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface EvictionFluent<A extends EvictionFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public DeleteOptions getDeleteOptions();
    public A withDeleteOptions(DeleteOptions deleteOptions);
    public Boolean hasDeleteOptions();
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata();
    public ObjectMeta buildMetadata();
    public A withMetadata(ObjectMeta metadata);
    public Boolean hasMetadata();
    public EvictionFluent.MetadataNested<A> withNewMetadata();
    public EvictionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EvictionFluent.MetadataNested<A> editMetadata();
    public EvictionFluent.MetadataNested<A> editOrNewMetadata();
    public EvictionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<EvictionFluent.MetadataNested<N>> {

            public N and();
            public N endMetadata();    }


}
