package io.fabric8.kubernetes.api.model.node.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OverheadBuilder extends OverheadFluentImpl<OverheadBuilder> implements VisitableBuilder<Overhead,OverheadBuilder>{
  public OverheadBuilder() {
    this(false);
  }
  public OverheadBuilder(Boolean validationEnabled) {
    this(new Overhead(), validationEnabled);
  }
  public OverheadBuilder(OverheadFluent<?> fluent) {
    this(fluent, false);
  }
  public OverheadBuilder(OverheadFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Overhead(), validationEnabled);
  }
  public OverheadBuilder(OverheadFluent<?> fluent,Overhead instance) {
    this(fluent, instance, false);
  }
  public OverheadBuilder(OverheadFluent<?> fluent,Overhead instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPodFixed(instance.getPodFixed()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OverheadBuilder(Overhead instance) {
    this(instance,false);
  }
  public OverheadBuilder(Overhead instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withPodFixed(instance.getPodFixed()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  OverheadFluent<?> fluent;
  Boolean validationEnabled;
  public Overhead build() {
    Overhead buildable = new Overhead(fluent.getPodFixed());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}