package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SchedulingBuilder extends SchedulingFluentImpl<SchedulingBuilder> implements VisitableBuilder<Scheduling,io.fabric8.kubernetes.api.model.node.v1.SchedulingBuilder>{
  public SchedulingBuilder() {
    this(false);
  }
  public SchedulingBuilder(Boolean validationEnabled) {
    this(new Scheduling(), validationEnabled);
  }
  public SchedulingBuilder(io.fabric8.kubernetes.api.model.node.v1.SchedulingFluent<?> fluent) {
    this(fluent, false);
  }
  public SchedulingBuilder(io.fabric8.kubernetes.api.model.node.v1.SchedulingFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Scheduling(), validationEnabled);
  }
  public SchedulingBuilder(io.fabric8.kubernetes.api.model.node.v1.SchedulingFluent<?> fluent,io.fabric8.kubernetes.api.model.node.v1.Scheduling instance) {
    this(fluent, instance, false);
  }
  public SchedulingBuilder(io.fabric8.kubernetes.api.model.node.v1.SchedulingFluent<?> fluent,io.fabric8.kubernetes.api.model.node.v1.Scheduling instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withTolerations(instance.getTolerations()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SchedulingBuilder(io.fabric8.kubernetes.api.model.node.v1.Scheduling instance) {
    this(instance,false);
  }
  public SchedulingBuilder(io.fabric8.kubernetes.api.model.node.v1.Scheduling instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withTolerations(instance.getTolerations()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.node.v1.SchedulingFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.node.v1.Scheduling build() {
    Scheduling buildable = new Scheduling(fluent.getNodeSelector(),fluent.getTolerations());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}