package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OverheadBuilder extends OverheadFluentImpl<OverheadBuilder> implements VisitableBuilder<Overhead,io.fabric8.kubernetes.api.model.node.v1.OverheadBuilder>{
  public OverheadBuilder() {
    this(false);
  }
  public OverheadBuilder(Boolean validationEnabled) {
    this(new Overhead(), validationEnabled);
  }
  public OverheadBuilder(OverheadFluent<?> fluent) {
    this(fluent, false);
  }
  public OverheadBuilder(io.fabric8.kubernetes.api.model.node.v1.OverheadFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Overhead(), validationEnabled);
  }
  public OverheadBuilder(io.fabric8.kubernetes.api.model.node.v1.OverheadFluent<?> fluent,io.fabric8.kubernetes.api.model.node.v1.Overhead instance) {
    this(fluent, instance, false);
  }
  public OverheadBuilder(io.fabric8.kubernetes.api.model.node.v1.OverheadFluent<?> fluent,io.fabric8.kubernetes.api.model.node.v1.Overhead instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withPodFixed(instance.getPodFixed()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public OverheadBuilder(io.fabric8.kubernetes.api.model.node.v1.Overhead instance) {
    this(instance,false);
  }
  public OverheadBuilder(io.fabric8.kubernetes.api.model.node.v1.Overhead instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withPodFixed(instance.getPodFixed()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.node.v1.OverheadFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.node.v1.Overhead build() {
    Overhead buildable = new Overhead(fluent.getPodFixed());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}