package io.fabric8.kubernetes.api.model.node.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Toleration;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class SchedulingFluentImpl<A extends io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingFluent<A> {

    private java.util.Map<String,String> nodeSelector;
    private List<Toleration> tolerations = new ArrayList<Toleration>();

    public SchedulingFluentImpl() {
    }

    public SchedulingFluentImpl(io.fabric8.kubernetes.api.model.node.v1alpha1.Scheduling instance) {
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withTolerations(instance.getTolerations()); 
    }

    public A addToNodeSelector(String key,String value) {
        if(this.nodeSelector == null && key != null && value != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(key != null && value != null) {this.nodeSelector.put(key, value);} return (A)this;
    }

    public A addToNodeSelector(java.util.Map<String,String> map) {
        if(this.nodeSelector == null && map != null) { this.nodeSelector = new LinkedHashMap<String,String>(); }
        if(map != null) { this.nodeSelector.putAll(map);} return (A)this;
    }

    public A removeFromNodeSelector(String key) {
        if(this.nodeSelector == null) { return (A) this; }
        if(key != null && this.nodeSelector != null) {this.nodeSelector.remove(key);} return (A)this;
    }

    public A removeFromNodeSelector(java.util.Map<String,String> map) {
        if(this.nodeSelector == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.nodeSelector != null){this.nodeSelector.remove(key);}}} return (A)this;
    }

    public java.util.Map<String,String> getNodeSelector() {
        return this.nodeSelector;
    }

    public <K extends Object,V extends Object>A withNodeSelector(java.util.Map<String,String> nodeSelector) {
        if (nodeSelector == null) { this.nodeSelector =  null;} else {this.nodeSelector = new LinkedHashMap<String,String>(nodeSelector);} return (A) this;
    }

    public Boolean hasNodeSelector() {
        return this.nodeSelector != null;
    }

    public A addToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.add(index, item);
        return (A)this;
    }

    public A setToTolerations(int index,Toleration item) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        this.tolerations.set(index, item); return (A)this;
    }

    public A addToTolerations(Toleration... items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A addAllToTolerations(Collection<Toleration> items) {
        if (this.tolerations == null) {this.tolerations = new ArrayList<Toleration>();}
        for (Toleration item : items) {this.tolerations.add(item);} return (A)this;
    }

    public A removeFromTolerations(Toleration... items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public A removeAllFromTolerations(Collection<Toleration> items) {
        for (Toleration item : items) {if (this.tolerations!= null){ this.tolerations.remove(item);}} return (A)this;
    }

    public List<Toleration> getTolerations() {
        return this.tolerations;
    }

    public Toleration getToleration(int index) {
        return this.tolerations.get(index);
    }

    public Toleration getFirstToleration() {
        return this.tolerations.get(0);
    }

    public Toleration getLastToleration() {
        return this.tolerations.get(tolerations.size() - 1);
    }

    public Toleration getMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingToleration(Predicate<Toleration> predicate) {
        for (Toleration item: tolerations) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withTolerations(List<Toleration> tolerations) {
        if (this.tolerations != null) { _visitables.get("tolerations").removeAll(this.tolerations);}
        if (tolerations != null) {this.tolerations = new ArrayList<Toleration>(); for (Toleration item : tolerations){this.addToTolerations(item);}} else { this.tolerations = null;} return (A) this;
    }

    public A withTolerations(Toleration... tolerations) {
        if (this.tolerations != null) {this.tolerations.clear();}
        if (tolerations != null) {for (Toleration item :tolerations){ this.addToTolerations(item);}} return (A) this;
    }

    public Boolean hasTolerations() {
        return tolerations != null && !tolerations.isEmpty();
    }

    public A addNewToleration(String effect,String key,String operator,Long tolerationSeconds,String value) {
        return (A)addToTolerations(new Toleration(effect, key, operator, tolerationSeconds, value));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        SchedulingFluentImpl that = (SchedulingFluentImpl) o;
        if (nodeSelector != null ? !nodeSelector.equals(that.nodeSelector) :that.nodeSelector != null) return false;
        if (tolerations != null ? !tolerations.equals(that.tolerations) :that.tolerations != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(nodeSelector,  tolerations,  super.hashCode());
    }

}
