package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class SchedulingBuilder extends SchedulingFluentImpl<SchedulingBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Scheduling,SchedulingBuilder> {

    SchedulingFluent<?> fluent;
    Boolean validationEnabled;

    public SchedulingBuilder() {
        this(true);
    }

    public SchedulingBuilder(Boolean validationEnabled) {
        this(new Scheduling(), validationEnabled);
    }

    public SchedulingBuilder(SchedulingFluent<?> fluent) {
        this(fluent, true);
    }

    public SchedulingBuilder(SchedulingFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Scheduling(), validationEnabled);
    }

    public SchedulingBuilder(SchedulingFluent<?> fluent,Scheduling instance) {
        this(fluent, instance, true);
    }

    public SchedulingBuilder(SchedulingFluent<?> fluent,Scheduling instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNodeSelector(instance.getNodeSelector()); 
        fluent.withTolerations(instance.getTolerations()); 
        this.validationEnabled = validationEnabled; 
    }

    public SchedulingBuilder(Scheduling instance) {
        this(instance,true);
    }

    public SchedulingBuilder(Scheduling instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withNodeSelector(instance.getNodeSelector()); 
        this.withTolerations(instance.getTolerations()); 
        this.validationEnabled = validationEnabled; 
    }

    public Scheduling build() {
        Scheduling buildable = new Scheduling(fluent.getNodeSelector(),fluent.getTolerations());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        SchedulingBuilder that = (SchedulingBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
