package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeClassBuilder extends RuntimeClassFluentImpl<RuntimeClassBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<RuntimeClass,RuntimeClassBuilder> {

    RuntimeClassFluent<?> fluent;
    Boolean validationEnabled;

    public RuntimeClassBuilder() {
        this(true);
    }

    public RuntimeClassBuilder(Boolean validationEnabled) {
        this(new RuntimeClass(), validationEnabled);
    }

    public RuntimeClassBuilder(RuntimeClassFluent<?> fluent) {
        this(fluent, true);
    }

    public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RuntimeClass(), validationEnabled);
    }

    public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,RuntimeClass instance) {
        this(fluent, instance, true);
    }

    public RuntimeClassBuilder(RuntimeClassFluent<?> fluent,RuntimeClass instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withHandler(instance.getHandler()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withOverhead(instance.getOverhead()); 
        fluent.withScheduling(instance.getScheduling()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeClassBuilder(RuntimeClass instance) {
        this(instance,true);
    }

    public RuntimeClassBuilder(RuntimeClass instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withHandler(instance.getHandler()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withOverhead(instance.getOverhead()); 
        this.withScheduling(instance.getScheduling()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeClass build() {
        RuntimeClass buildable = new RuntimeClass(fluent.getApiVersion(),fluent.getHandler(),fluent.getKind(),fluent.getMetadata(),fluent.getOverhead(),fluent.getScheduling());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuntimeClassBuilder that = (RuntimeClassBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
