package io.fabric8.kubernetes.api.model.node.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.StringBuffer;
import java.lang.Object;

public class RuntimeClassFluentImpl<A extends RuntimeClassFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuntimeClassFluent<A> {

    private String apiVersion;
    private String handler;
    private String kind;
    private ObjectMetaBuilder metadata;
    private OverheadBuilder overhead;
    private SchedulingBuilder scheduling;

    public RuntimeClassFluentImpl() {
    }

    public RuntimeClassFluentImpl(RuntimeClass instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withHandler(instance.getHandler()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withOverhead(instance.getOverhead()); 
        this.withScheduling(instance.getScheduling()); 
    }

    public String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    public A withNewApiVersion(StringBuilder arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(int[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(char[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(StringBuffer arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(byte[] arg1,int arg2) {
        return (A)withApiVersion(new String(arg1, arg2));
    }

    public A withNewApiVersion(byte[] arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public A withNewApiVersion(char[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3) {
        return (A)withApiVersion(new String(arg1, arg2, arg3));
    }

    public A withNewApiVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withApiVersion(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewApiVersion(String arg1) {
        return (A)withApiVersion(new String(arg1));
    }

    public String getHandler() {
        return this.handler;
    }

    public A withHandler(String handler) {
        this.handler=handler; return (A) this;
    }

    public Boolean hasHandler() {
        return this.handler != null;
    }

    public A withNewHandler(StringBuilder arg1) {
        return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(int[] arg1,int arg2,int arg3) {
        return (A)withHandler(new String(arg1, arg2, arg3));
    }

    public A withNewHandler(char[] arg1) {
        return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(StringBuffer arg1) {
        return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(byte[] arg1,int arg2) {
        return (A)withHandler(new String(arg1, arg2));
    }

    public A withNewHandler(byte[] arg1) {
        return (A)withHandler(new String(arg1));
    }

    public A withNewHandler(char[] arg1,int arg2,int arg3) {
        return (A)withHandler(new String(arg1, arg2, arg3));
    }

    public A withNewHandler(byte[] arg1,int arg2,int arg3) {
        return (A)withHandler(new String(arg1, arg2, arg3));
    }

    public A withNewHandler(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withHandler(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewHandler(String arg1) {
        return (A)withHandler(new String(arg1));
    }

    public String getKind() {
        return this.kind;
    }

    public A withKind(String kind) {
        this.kind=kind; return (A) this;
    }

    public Boolean hasKind() {
        return this.kind != null;
    }

    public A withNewKind(StringBuilder arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(int[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(char[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(StringBuffer arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(byte[] arg1,int arg2) {
        return (A)withKind(new String(arg1, arg2));
    }

    public A withNewKind(byte[] arg1) {
        return (A)withKind(new String(arg1));
    }

    public A withNewKind(char[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3) {
        return (A)withKind(new String(arg1, arg2, arg3));
    }

    public A withNewKind(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withKind(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewKind(String arg1) {
        return (A)withKind(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetadata instead.
 * @return The buildable object.
 */
@Deprecated public ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.MetadataNested<A> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    
/**
 * This method has been deprecated, please use method buildOverhead instead.
 * @return The buildable object.
 */
@Deprecated public Overhead getOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public Overhead buildOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public A withOverhead(Overhead overhead) {
        _visitables.get("overhead").remove(this.overhead);
        if (overhead!=null){ this.overhead= new OverheadBuilder(overhead); _visitables.get("overhead").add(this.overhead);} return (A) this;
    }

    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.OverheadNested<A> withNewOverhead() {
        return new OverheadNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.OverheadNested<A> withNewOverheadLike(Overhead item) {
        return new OverheadNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.OverheadNested<A> editOverhead() {
        return withNewOverheadLike(getOverhead());
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.OverheadNested<A> editOrNewOverhead() {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): new OverheadBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.OverheadNested<A> editOrNewOverheadLike(Overhead item) {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): item);
    }

    
/**
 * This method has been deprecated, please use method buildScheduling instead.
 * @return The buildable object.
 */
@Deprecated public Scheduling getScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public Scheduling buildScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public A withScheduling(Scheduling scheduling) {
        _visitables.get("scheduling").remove(this.scheduling);
        if (scheduling!=null){ this.scheduling= new SchedulingBuilder(scheduling); _visitables.get("scheduling").add(this.scheduling);} return (A) this;
    }

    public Boolean hasScheduling() {
        return this.scheduling != null;
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.SchedulingNested<A> withNewScheduling() {
        return new SchedulingNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
        return new SchedulingNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.SchedulingNested<A> editScheduling() {
        return withNewSchedulingLike(getScheduling());
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.SchedulingNested<A> editOrNewScheduling() {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): new SchedulingBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RuntimeClassFluentImpl that = (RuntimeClassFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (handler != null ? !handler.equals(that.handler) :that.handler != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
        if (scheduling != null ? !scheduling.equals(that.scheduling) :that.scheduling != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  handler,  kind,  metadata,  overhead,  scheduling,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final ObjectMetaBuilder builder;

            MetadataNestedImpl(ObjectMeta item) {
                this.builder = new ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) RuntimeClassFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class OverheadNestedImpl<N> extends OverheadFluentImpl<io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.OverheadNested<N>> implements io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.OverheadNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OverheadBuilder builder;

            OverheadNestedImpl(Overhead item) {
                this.builder = new OverheadBuilder(this, item);
                        
            }

            OverheadNestedImpl() {
                this.builder = new OverheadBuilder(this);
                        
            }

            public N and() {
                return (N) RuntimeClassFluentImpl.this.withOverhead(builder.build());
            }

            public N endOverhead() {
                return and();
            }
    }


    public class SchedulingNestedImpl<N> extends SchedulingFluentImpl<io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.SchedulingNested<N>> implements io.fabric8.kubernetes.api.model.node.v1.RuntimeClassFluent.SchedulingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulingBuilder builder;

            SchedulingNestedImpl(Scheduling item) {
                this.builder = new SchedulingBuilder(this, item);
                        
            }

            SchedulingNestedImpl() {
                this.builder = new SchedulingBuilder(this);
                        
            }

            public N and() {
                return (N) RuntimeClassFluentImpl.this.withScheduling(builder.build());
            }

            public N endScheduling() {
                return and();
            }
    }


}
