package io.fabric8.kubernetes.api.model.node.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeClassSpecFluentImpl<A extends RuntimeClassSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuntimeClassSpecFluent<A> {

    private io.fabric8.kubernetes.api.model.node.v1alpha1.OverheadBuilder overhead;
    private String runtimeHandler;
    private io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingBuilder scheduling;

    public RuntimeClassSpecFluentImpl() {
    }

    public RuntimeClassSpecFluentImpl(RuntimeClassSpec instance) {
        this.withOverhead(instance.getOverhead()); 
        this.withRuntimeHandler(instance.getRuntimeHandler()); 
        this.withScheduling(instance.getScheduling()); 
    }

    
/**
 * This method has been deprecated, please use method buildOverhead instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.node.v1alpha1.Overhead getOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.Overhead buildOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public A withOverhead(io.fabric8.kubernetes.api.model.node.v1alpha1.Overhead overhead) {
        _visitables.get("overhead").remove(this.overhead);
        if (overhead!=null){ this.overhead= new io.fabric8.kubernetes.api.model.node.v1alpha1.OverheadBuilder(overhead); _visitables.get("overhead").add(this.overhead);} return (A) this;
    }

    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.OverheadNested<A> withNewOverhead() {
        return new OverheadNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.OverheadNested<A> withNewOverheadLike(io.fabric8.kubernetes.api.model.node.v1alpha1.Overhead item) {
        return new OverheadNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.OverheadNested<A> editOverhead() {
        return withNewOverheadLike(getOverhead());
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.OverheadNested<A> editOrNewOverhead() {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): new io.fabric8.kubernetes.api.model.node.v1alpha1.OverheadBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.OverheadNested<A> editOrNewOverheadLike(io.fabric8.kubernetes.api.model.node.v1alpha1.Overhead item) {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): item);
    }

    public String getRuntimeHandler() {
        return this.runtimeHandler;
    }

    public A withRuntimeHandler(String runtimeHandler) {
        this.runtimeHandler=runtimeHandler; return (A) this;
    }

    public Boolean hasRuntimeHandler() {
        return this.runtimeHandler != null;
    }

    public A withNewRuntimeHandler(StringBuilder arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(int[] arg1,int arg2,int arg3) {
        return (A)withRuntimeHandler(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeHandler(char[] arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(StringBuffer arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(byte[] arg1,int arg2) {
        return (A)withRuntimeHandler(new String(arg1, arg2));
    }

    public A withNewRuntimeHandler(byte[] arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(char[] arg1,int arg2,int arg3) {
        return (A)withRuntimeHandler(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeHandler(byte[] arg1,int arg2,int arg3) {
        return (A)withRuntimeHandler(new String(arg1, arg2, arg3));
    }

    public A withNewRuntimeHandler(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withRuntimeHandler(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewRuntimeHandler(String arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduling instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.node.v1alpha1.Scheduling getScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.Scheduling buildScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public A withScheduling(io.fabric8.kubernetes.api.model.node.v1alpha1.Scheduling scheduling) {
        _visitables.get("scheduling").remove(this.scheduling);
        if (scheduling!=null){ this.scheduling= new io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingBuilder(scheduling); _visitables.get("scheduling").add(this.scheduling);} return (A) this;
    }

    public Boolean hasScheduling() {
        return this.scheduling != null;
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.SchedulingNested<A> withNewScheduling() {
        return new SchedulingNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.SchedulingNested<A> withNewSchedulingLike(io.fabric8.kubernetes.api.model.node.v1alpha1.Scheduling item) {
        return new SchedulingNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.SchedulingNested<A> editScheduling() {
        return withNewSchedulingLike(getScheduling());
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.SchedulingNested<A> editOrNewScheduling() {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): new io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.SchedulingNested<A> editOrNewSchedulingLike(io.fabric8.kubernetes.api.model.node.v1alpha1.Scheduling item) {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RuntimeClassSpecFluentImpl that = (RuntimeClassSpecFluentImpl) o;
        if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
        if (runtimeHandler != null ? !runtimeHandler.equals(that.runtimeHandler) :that.runtimeHandler != null) return false;
        if (scheduling != null ? !scheduling.equals(that.scheduling) :that.scheduling != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(overhead,  runtimeHandler,  scheduling,  super.hashCode());
    }

    public class OverheadNestedImpl<N> extends io.fabric8.kubernetes.api.model.node.v1alpha1.OverheadFluentImpl<io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.OverheadNested<N>> implements io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.OverheadNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.node.v1alpha1.OverheadBuilder builder;

            OverheadNestedImpl(io.fabric8.kubernetes.api.model.node.v1alpha1.Overhead item) {
                this.builder = new io.fabric8.kubernetes.api.model.node.v1alpha1.OverheadBuilder(this, item);
                        
            }

            OverheadNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.node.v1alpha1.OverheadBuilder(this);
                        
            }

            public N and() {
                return (N) RuntimeClassSpecFluentImpl.this.withOverhead(builder.build());
            }

            public N endOverhead() {
                return and();
            }
    }


    public class SchedulingNestedImpl<N> extends io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingFluentImpl<io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.SchedulingNested<N>> implements io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassSpecFluent.SchedulingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingBuilder builder;

            SchedulingNestedImpl(io.fabric8.kubernetes.api.model.node.v1alpha1.Scheduling item) {
                this.builder = new io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingBuilder(this, item);
                        
            }

            SchedulingNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.node.v1alpha1.SchedulingBuilder(this);
                        
            }

            public N and() {
                return (N) RuntimeClassSpecFluentImpl.this.withScheduling(builder.build());
            }

            public N endScheduling() {
                return and();
            }
    }


}
