package io.fabric8.kubernetes.api.model.node.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class OverheadBuilder extends OverheadFluentImpl<OverheadBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<Overhead,OverheadBuilder> {

    OverheadFluent<?> fluent;
    Boolean validationEnabled;

    public OverheadBuilder() {
        this(true);
    }

    public OverheadBuilder(Boolean validationEnabled) {
        this(new Overhead(), validationEnabled);
    }

    public OverheadBuilder(OverheadFluent<?> fluent) {
        this(fluent, true);
    }

    public OverheadBuilder(OverheadFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new Overhead(), validationEnabled);
    }

    public OverheadBuilder(OverheadFluent<?> fluent,Overhead instance) {
        this(fluent, instance, true);
    }

    public OverheadBuilder(OverheadFluent<?> fluent,Overhead instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withPodFixed(instance.getPodFixed()); 
        this.validationEnabled = validationEnabled; 
    }

    public OverheadBuilder(Overhead instance) {
        this(instance,true);
    }

    public OverheadBuilder(Overhead instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withPodFixed(instance.getPodFixed()); 
        this.validationEnabled = validationEnabled; 
    }

    public Overhead build() {
        Overhead buildable = new Overhead(fluent.getPodFixed());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        OverheadBuilder that = (OverheadBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
