package io.fabric8.kubernetes.api.model.node.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeClassSpecBuilder extends RuntimeClassSpecFluentImpl<RuntimeClassSpecBuilder> implements VisitableBuilder<RuntimeClassSpec,RuntimeClassSpecBuilder> {

    RuntimeClassSpecFluent<?> fluent;
    Boolean validationEnabled;

    public RuntimeClassSpecBuilder() {
        this(true);
    }

    public RuntimeClassSpecBuilder(Boolean validationEnabled) {
        this(new RuntimeClassSpec(), validationEnabled);
    }

    public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RuntimeClassSpec(), validationEnabled);
    }

    public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent,RuntimeClassSpec instance) {
        this(fluent, instance, true);
    }

    public RuntimeClassSpecBuilder(RuntimeClassSpecFluent<?> fluent,RuntimeClassSpec instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withOverhead(instance.getOverhead()); 
        fluent.withRuntimeHandler(instance.getRuntimeHandler()); 
        fluent.withScheduling(instance.getScheduling()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeClassSpecBuilder(RuntimeClassSpec instance) {
        this(instance,true);
    }

    public RuntimeClassSpecBuilder(RuntimeClassSpec instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withOverhead(instance.getOverhead()); 
        this.withRuntimeHandler(instance.getRuntimeHandler()); 
        this.withScheduling(instance.getScheduling()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeClassSpec build() {
        RuntimeClassSpec buildable = new RuntimeClassSpec(fluent.getOverhead(),fluent.getRuntimeHandler(),fluent.getScheduling());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuntimeClassSpecBuilder that = (RuntimeClassSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
