package io.fabric8.kubernetes.api.model.node.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeClassBuilder extends io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassFluentImpl<io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClass,io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassBuilder> {

    io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassFluent<?> fluent;
    Boolean validationEnabled;

    public RuntimeClassBuilder() {
        this(true);
    }

    public RuntimeClassBuilder(Boolean validationEnabled) {
        this(new RuntimeClass(), validationEnabled);
    }

    public RuntimeClassBuilder(io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassFluent<?> fluent) {
        this(fluent, true);
    }

    public RuntimeClassBuilder(io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new RuntimeClass(), validationEnabled);
    }

    public RuntimeClassBuilder(io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassFluent<?> fluent,io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClass instance) {
        this(fluent, instance, true);
    }

    public RuntimeClassBuilder(io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClassFluent<?> fluent,io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClass instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public RuntimeClassBuilder(io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClass instance) {
        this(instance,true);
    }

    public RuntimeClassBuilder(io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClass instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.node.v1alpha1.RuntimeClass build() {
        RuntimeClass buildable = new RuntimeClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        RuntimeClassBuilder that = (RuntimeClassBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
