package io.fabric8.kubernetes.api.model.node.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

public class OverheadFluentImpl<A extends io.fabric8.kubernetes.api.model.node.v1beta1.OverheadFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.node.v1beta1.OverheadFluent<A> {

    private Map<String,Quantity> podFixed;

    public OverheadFluentImpl() {
    }

    public OverheadFluentImpl(io.fabric8.kubernetes.api.model.node.v1beta1.Overhead instance) {
        this.withPodFixed(instance.getPodFixed()); 
    }

    public A addToPodFixed(String key,Quantity value) {
        if(this.podFixed == null && key != null && value != null) { this.podFixed = new LinkedHashMap<String,Quantity>(); }
        if(key != null && value != null) {this.podFixed.put(key, value);} return (A)this;
    }

    public A addToPodFixed(Map<String,Quantity> map) {
        if(this.podFixed == null && map != null) { this.podFixed = new LinkedHashMap<String,Quantity>(); }
        if(map != null) { this.podFixed.putAll(map);} return (A)this;
    }

    public A removeFromPodFixed(String key) {
        if(this.podFixed == null) { return (A) this; }
        if(key != null && this.podFixed != null) {this.podFixed.remove(key);} return (A)this;
    }

    public A removeFromPodFixed(Map<String,Quantity> map) {
        if(this.podFixed == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.podFixed != null){this.podFixed.remove(key);}}} return (A)this;
    }

    public Map<String,Quantity> getPodFixed() {
        return this.podFixed;
    }

    public A withPodFixed(Map<String,Quantity> podFixed) {
        if (podFixed == null) { this.podFixed =  null;} else {this.podFixed = new LinkedHashMap<String,Quantity>(podFixed);} return (A) this;
    }

    public Boolean hasPodFixed() {
        return this.podFixed != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        OverheadFluentImpl that = (OverheadFluentImpl) o;
        if (podFixed != null ? !podFixed.equals(that.podFixed) :that.podFixed != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(podFixed,  super.hashCode());
    }

}
