package io.fabric8.kubernetes.api.model.node.v1alpha1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class RuntimeClassSpecFluentImpl<A extends RuntimeClassSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements RuntimeClassSpecFluent<A> {

    private OverheadBuilder overhead;
    private String runtimeHandler;
    private SchedulingBuilder scheduling;

    public RuntimeClassSpecFluentImpl() {
    }

    public RuntimeClassSpecFluentImpl(RuntimeClassSpec instance) {
        this.withOverhead(instance.getOverhead()); 
        this.withRuntimeHandler(instance.getRuntimeHandler()); 
        this.withScheduling(instance.getScheduling()); 
    }

    
/**
 * This method has been deprecated, please use method buildOverhead instead.
 * @return The buildable object.
 */
@Deprecated public Overhead getOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public Overhead buildOverhead() {
        return this.overhead!=null?this.overhead.build():null;
    }

    public A withOverhead(Overhead overhead) {
        _visitables.get("overhead").remove(this.overhead);
        if (overhead!=null){ this.overhead= new OverheadBuilder(overhead); _visitables.get("overhead").add(this.overhead);} return (A) this;
    }

    public Boolean hasOverhead() {
        return this.overhead != null;
    }

    public RuntimeClassSpecFluent.OverheadNested<A> withNewOverhead() {
        return new OverheadNestedImpl();
    }

    public RuntimeClassSpecFluent.OverheadNested<A> withNewOverheadLike(Overhead item) {
        return new OverheadNestedImpl(item);
    }

    public RuntimeClassSpecFluent.OverheadNested<A> editOverhead() {
        return withNewOverheadLike(getOverhead());
    }

    public RuntimeClassSpecFluent.OverheadNested<A> editOrNewOverhead() {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): new OverheadBuilder().build());
    }

    public RuntimeClassSpecFluent.OverheadNested<A> editOrNewOverheadLike(Overhead item) {
        return withNewOverheadLike(getOverhead() != null ? getOverhead(): item);
    }

    public String getRuntimeHandler() {
        return this.runtimeHandler;
    }

    public A withRuntimeHandler(String runtimeHandler) {
        this.runtimeHandler=runtimeHandler; return (A) this;
    }

    public Boolean hasRuntimeHandler() {
        return this.runtimeHandler != null;
    }

    public A withNewRuntimeHandler(String arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(StringBuilder arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    public A withNewRuntimeHandler(StringBuffer arg1) {
        return (A)withRuntimeHandler(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildScheduling instead.
 * @return The buildable object.
 */
@Deprecated public Scheduling getScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public Scheduling buildScheduling() {
        return this.scheduling!=null?this.scheduling.build():null;
    }

    public A withScheduling(Scheduling scheduling) {
        _visitables.get("scheduling").remove(this.scheduling);
        if (scheduling!=null){ this.scheduling= new SchedulingBuilder(scheduling); _visitables.get("scheduling").add(this.scheduling);} return (A) this;
    }

    public Boolean hasScheduling() {
        return this.scheduling != null;
    }

    public RuntimeClassSpecFluent.SchedulingNested<A> withNewScheduling() {
        return new SchedulingNestedImpl();
    }

    public RuntimeClassSpecFluent.SchedulingNested<A> withNewSchedulingLike(Scheduling item) {
        return new SchedulingNestedImpl(item);
    }

    public RuntimeClassSpecFluent.SchedulingNested<A> editScheduling() {
        return withNewSchedulingLike(getScheduling());
    }

    public RuntimeClassSpecFluent.SchedulingNested<A> editOrNewScheduling() {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): new SchedulingBuilder().build());
    }

    public RuntimeClassSpecFluent.SchedulingNested<A> editOrNewSchedulingLike(Scheduling item) {
        return withNewSchedulingLike(getScheduling() != null ? getScheduling(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        RuntimeClassSpecFluentImpl that = (RuntimeClassSpecFluentImpl) o;
        if (overhead != null ? !overhead.equals(that.overhead) :that.overhead != null) return false;
        if (runtimeHandler != null ? !runtimeHandler.equals(that.runtimeHandler) :that.runtimeHandler != null) return false;
        if (scheduling != null ? !scheduling.equals(that.scheduling) :that.scheduling != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(overhead,  runtimeHandler,  scheduling,  super.hashCode());
    }

    public class OverheadNestedImpl<N> extends OverheadFluentImpl<RuntimeClassSpecFluent.OverheadNested<N>> implements RuntimeClassSpecFluent.OverheadNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final OverheadBuilder builder;

            OverheadNestedImpl(Overhead item) {
                this.builder = new OverheadBuilder(this, item);
                        
            }

            OverheadNestedImpl() {
                this.builder = new OverheadBuilder(this);
                        
            }

            public N and() {
                return (N) RuntimeClassSpecFluentImpl.this.withOverhead(builder.build());
            }

            public N endOverhead() {
                return and();
            }
    }


    public class SchedulingNestedImpl<N> extends SchedulingFluentImpl<RuntimeClassSpecFluent.SchedulingNested<N>> implements RuntimeClassSpecFluent.SchedulingNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final SchedulingBuilder builder;

            SchedulingNestedImpl(Scheduling item) {
                this.builder = new SchedulingBuilder(this, item);
                        
            }

            SchedulingNestedImpl() {
                this.builder = new SchedulingBuilder(this);
                        
            }

            public N and() {
                return (N) RuntimeClassSpecFluentImpl.this.withScheduling(builder.build());
            }

            public N endScheduling() {
                return and();
            }
    }


}
