package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterCIDRSpecBuilder extends ClusterCIDRSpecFluent<ClusterCIDRSpecBuilder> implements VisitableBuilder<ClusterCIDRSpec,ClusterCIDRSpecBuilder>{
  public ClusterCIDRSpecBuilder() {
    this(new ClusterCIDRSpec());
  }
  
  public ClusterCIDRSpecBuilder(ClusterCIDRSpecFluent<?> fluent) {
    this(fluent, new ClusterCIDRSpec());
  }
  
  public ClusterCIDRSpecBuilder(ClusterCIDRSpecFluent<?> fluent,ClusterCIDRSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterCIDRSpecBuilder(ClusterCIDRSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterCIDRSpecFluent<?> fluent;
  
  public ClusterCIDRSpec build() {
    ClusterCIDRSpec buildable = new ClusterCIDRSpec(fluent.getIpv4(),fluent.getIpv6(),fluent.getNodeSelector(),fluent.getPerNodeHostBits());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}