package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ClusterCIDRBuilder extends ClusterCIDRFluent<ClusterCIDRBuilder> implements VisitableBuilder<ClusterCIDR,ClusterCIDRBuilder>{
  public ClusterCIDRBuilder() {
    this(new ClusterCIDR());
  }
  
  public ClusterCIDRBuilder(ClusterCIDRFluent<?> fluent) {
    this(fluent, new ClusterCIDR());
  }
  
  public ClusterCIDRBuilder(ClusterCIDRFluent<?> fluent,ClusterCIDR instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ClusterCIDRBuilder(ClusterCIDR instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ClusterCIDRFluent<?> fluent;
  
  public ClusterCIDR build() {
    ClusterCIDR buildable = new ClusterCIDR(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}