package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressClassSpecBuilder extends IngressClassSpecFluent<IngressClassSpecBuilder> implements VisitableBuilder<IngressClassSpec,IngressClassSpecBuilder>{
  public IngressClassSpecBuilder() {
    this(false);
  }
  public IngressClassSpecBuilder(Boolean validationEnabled) {
    this(new IngressClassSpec(), validationEnabled);
  }
  public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressClassSpec(), validationEnabled);
  }
  public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent,IngressClassSpec instance) {
    this(fluent, instance, false);
  }
  public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent,IngressClassSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new IngressClassSpec());

    if (instance != null) {
      fluent.withController(instance.getController());
      fluent.withParameters(instance.getParameters());
      fluent.withController(instance.getController());
      fluent.withParameters(instance.getParameters());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IngressClassSpecBuilder(IngressClassSpec instance) {
    this(instance,false);
  }
  public IngressClassSpecBuilder(IngressClassSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new IngressClassSpec());

    if (instance != null) {
      this.withController(instance.getController());
      this.withParameters(instance.getParameters());
      this.withController(instance.getController());
      this.withParameters(instance.getParameters());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  IngressClassSpecFluent<?> fluent;
  Boolean validationEnabled;
  public IngressClassSpec build() {
    IngressClassSpec buildable = new IngressClassSpec(fluent.getController(),fluent.buildParameters());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}