package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBackendPortBuilder extends ServiceBackendPortFluent<ServiceBackendPortBuilder> implements VisitableBuilder<ServiceBackendPort,ServiceBackendPortBuilder>{
  public ServiceBackendPortBuilder() {
    this(false);
  }
  public ServiceBackendPortBuilder(Boolean validationEnabled) {
    this(new ServiceBackendPort(), validationEnabled);
  }
  public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceBackendPort(), validationEnabled);
  }
  public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent,ServiceBackendPort instance) {
    this(fluent, instance, false);
  }
  public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent,ServiceBackendPort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceBackendPort());

    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withNumber(instance.getNumber());
      fluent.withName(instance.getName());
      fluent.withNumber(instance.getNumber());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceBackendPortBuilder(ServiceBackendPort instance) {
    this(instance,false);
  }
  public ServiceBackendPortBuilder(ServiceBackendPort instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceBackendPort());

    if (instance != null) {
      this.withName(instance.getName());
      this.withNumber(instance.getNumber());
      this.withName(instance.getName());
      this.withNumber(instance.getNumber());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceBackendPortFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceBackendPort build() {
    ServiceBackendPort buildable = new ServiceBackendPort(fluent.getName(),fluent.getNumber());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}