package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkPolicyIngressRuleFluent<A extends NetworkPolicyIngressRuleFluent<A>> extends BaseFluent<A>{
  public NetworkPolicyIngressRuleFluent() {
  }
  public NetworkPolicyIngressRuleFluent(NetworkPolicyIngressRule instance) {
    instance = (instance != null ? instance : new NetworkPolicyIngressRule());

    if (instance != null) {
      this.withFrom(instance.getFrom());
      this.withPorts(instance.getPorts());
      this.withFrom(instance.getFrom());
      this.withPorts(instance.getPorts());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ArrayList<NetworkPolicyPeerBuilder> from = new ArrayList<NetworkPolicyPeerBuilder>();
  private ArrayList<NetworkPolicyPortBuilder> ports = new ArrayList<NetworkPolicyPortBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToFrom(int index,NetworkPolicyPeer item) {
    if (this.from == null) {this.from = new ArrayList<NetworkPolicyPeerBuilder>();}
    NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
    if (index < 0 || index >= from.size()) { _visitables.get("from").add(builder); from.add(builder); } else { _visitables.get("from").add(index, builder); from.add(index, builder);}
    return (A)this;
  }
  public A setToFrom(int index,NetworkPolicyPeer item) {
    if (this.from == null) {this.from = new ArrayList<NetworkPolicyPeerBuilder>();}
    NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);
    if (index < 0 || index >= from.size()) { _visitables.get("from").add(builder); from.add(builder); } else { _visitables.get("from").set(index, builder); from.set(index, builder);}
    return (A)this;
  }
  public A addToFrom(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
    if (this.from == null) {this.from = new ArrayList<NetworkPolicyPeerBuilder>();}
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
  }
  public A addAllToFrom(Collection<NetworkPolicyPeer> items) {
    if (this.from == null) {this.from = new ArrayList<NetworkPolicyPeerBuilder>();}
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("from").add(builder);this.from.add(builder);} return (A)this;
  }
  public A removeFromFrom(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
    if (this.from == null) return (A)this;
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("from").remove(builder); this.from.remove(builder);} return (A)this;
  }
  public A removeAllFromFrom(Collection<NetworkPolicyPeer> items) {
    if (this.from == null) return (A)this;
    for (NetworkPolicyPeer item : items) {NetworkPolicyPeerBuilder builder = new NetworkPolicyPeerBuilder(item);_visitables.get("from").remove(builder); this.from.remove(builder);} return (A)this;
  }
  public A removeMatchingFromFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
    if (from == null) return (A) this;
    final Iterator<NetworkPolicyPeerBuilder> each = from.iterator();
    final List visitables = _visitables.get("from");
    while (each.hasNext()) {
      NetworkPolicyPeerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<NetworkPolicyPeer> buildFrom() {
    return from != null ? build(from) : null;
  }
  public NetworkPolicyPeer buildFrom(int index) {
    return this.from.get(index).build();
  }
  public NetworkPolicyPeer buildFirstFrom() {
    return this.from.get(0).build();
  }
  public NetworkPolicyPeer buildLastFrom() {
    return this.from.get(from.size() - 1).build();
  }
  public NetworkPolicyPeer buildMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
    for (NetworkPolicyPeerBuilder item: from) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
    for (NetworkPolicyPeerBuilder item: from) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFrom(List<NetworkPolicyPeer> from) {
    if (this.from != null) { _visitables.get("from").clear();}
    if (from != null) {this.from = new ArrayList(); for (NetworkPolicyPeer item : from){this.addToFrom(item);}} else { this.from = null;} return (A) this;
  }
  public A withFrom(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... from) {
    if (this.from != null) {this.from.clear(); _visitables.remove("from"); }
    if (from != null) {for (NetworkPolicyPeer item :from){ this.addToFrom(item);}} return (A) this;
  }
  public boolean hasFrom() {
    return from != null && !from.isEmpty();
  }
  public FromNested<A> addNewFrom() {
    return new FromNested(-1, null);
  }
  public FromNested<A> addNewFromLike(NetworkPolicyPeer item) {
    return new FromNested(-1, item);
  }
  public FromNested<A> setNewFromLike(int index,NetworkPolicyPeer item) {
    return new FromNested(index, item);
  }
  public FromNested<A> editFrom(int index) {
    if (from.size() <= index) throw new RuntimeException("Can't edit from. Index exceeds size.");
    return setNewFromLike(index, buildFrom(index));
  }
  public FromNested<A> editFirstFrom() {
    if (from.size() == 0) throw new RuntimeException("Can't edit first from. The list is empty.");
    return setNewFromLike(0, buildFrom(0));
  }
  public FromNested<A> editLastFrom() {
    int index = from.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last from. The list is empty.");
    return setNewFromLike(index, buildFrom(index));
  }
  public FromNested<A> editMatchingFrom(Predicate<NetworkPolicyPeerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<from.size();i++) { 
    if (predicate.test(from.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching from. No match found.");
    return setNewFromLike(index, buildFrom(index));
  }
  public A addToPorts(int index,NetworkPolicyPort item) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").add(index, builder); ports.add(index, builder);}
    return (A)this;
  }
  public A setToPorts(int index,NetworkPolicyPort item) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);
    if (index < 0 || index >= ports.size()) { _visitables.get("ports").add(builder); ports.add(builder); } else { _visitables.get("ports").set(index, builder); ports.set(index, builder);}
    return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort... items) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(Collection<NetworkPolicyPort> items) {
    if (this.ports == null) {this.ports = new ArrayList<NetworkPolicyPortBuilder>();}
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort... items) {
    if (this.ports == null) return (A)this;
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  public A removeAllFromPorts(Collection<NetworkPolicyPort> items) {
    if (this.ports == null) return (A)this;
    for (NetworkPolicyPort item : items) {NetworkPolicyPortBuilder builder = new NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder); this.ports.remove(builder);} return (A)this;
  }
  public A removeMatchingFromPorts(Predicate<NetworkPolicyPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<NetworkPolicyPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      NetworkPolicyPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  public List<NetworkPolicyPort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public NetworkPolicyPort buildPort(int index) {
    return this.ports.get(index).build();
  }
  public NetworkPolicyPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public NetworkPolicyPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public NetworkPolicyPort buildMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
    for (NetworkPolicyPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public boolean hasMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
    for (NetworkPolicyPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(List<NetworkPolicyPort> ports) {
    if (this.ports != null) { _visitables.get("ports").clear();}
    if (ports != null) {this.ports = new ArrayList(); for (NetworkPolicyPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort... ports) {
    if (this.ports != null) {this.ports.clear(); _visitables.remove("ports"); }
    if (ports != null) {for (NetworkPolicyPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public PortsNested<A> addNewPort() {
    return new PortsNested(-1, null);
  }
  public PortsNested<A> addNewPortLike(NetworkPolicyPort item) {
    return new PortsNested(-1, item);
  }
  public PortsNested<A> setNewPortLike(int index,NetworkPolicyPort item) {
    return new PortsNested(index, item);
  }
  public PortsNested<A> editPort(int index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public PortsNested<A> editMatchingPort(Predicate<NetworkPolicyPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    NetworkPolicyIngressRuleFluent that = (NetworkPolicyIngressRuleFluent) o;
    if (!java.util.Objects.equals(from, that.from)) return false;

    if (!java.util.Objects.equals(ports, that.ports)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(from,  ports,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (from != null && !from.isEmpty()) { sb.append("from:"); sb.append(from + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class FromNested<N> extends NetworkPolicyPeerFluent<FromNested<N>> implements Nested<N>{
    FromNested(int index,NetworkPolicyPeer item) {
      this.index = index;
      this.builder = new NetworkPolicyPeerBuilder(this, item);
    }
    NetworkPolicyPeerBuilder builder;
    int index;
    public N and() {
      return (N) NetworkPolicyIngressRuleFluent.this.setToFrom(index,builder.build());
    }
    public N endFrom() {
      return and();
    }
    
  }
  public class PortsNested<N> extends NetworkPolicyPortFluent<PortsNested<N>> implements Nested<N>{
    PortsNested(int index,NetworkPolicyPort item) {
      this.index = index;
      this.builder = new NetworkPolicyPortBuilder(this, item);
    }
    NetworkPolicyPortBuilder builder;
    int index;
    public N and() {
      return (N) NetworkPolicyIngressRuleFluent.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  
}