package io.fabric8.kubernetes.api.model.networking.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPIngressPathFluent<A extends HTTPIngressPathFluent<A>> extends BaseFluent<A>{
  public HTTPIngressPathFluent() {
  }
  public HTTPIngressPathFluent(HTTPIngressPath instance) {
    instance = (instance != null ? instance : new HTTPIngressPath());

    if (instance != null) {
      this.withBackend(instance.getBackend());
      this.withPath(instance.getPath());
      this.withPathType(instance.getPathType());
      this.withBackend(instance.getBackend());
      this.withPath(instance.getPath());
      this.withPathType(instance.getPathType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private IngressBackendBuilder backend;
  private String path;
  private String pathType;
  private Map<String,Object> additionalProperties;
  public IngressBackend buildBackend() {
    return this.backend!=null ?this.backend.build():null;
  }
  public A withBackend(IngressBackend backend) {
    _visitables.get("backend").remove(this.backend);
    if (backend!=null){ this.backend= new IngressBackendBuilder(backend); _visitables.get("backend").add(this.backend);} else { this.backend = null; _visitables.get("backend").remove(this.backend); } return (A) this;
  }
  public boolean hasBackend() {
    return this.backend != null;
  }
  public BackendNested<A> withNewBackend() {
    return new BackendNested(null);
  }
  public BackendNested<A> withNewBackendLike(IngressBackend item) {
    return new BackendNested(item);
  }
  public BackendNested<A> editBackend() {
    return withNewBackendLike(java.util.Optional.ofNullable(buildBackend()).orElse(null));
  }
  public BackendNested<A> editOrNewBackend() {
    return withNewBackendLike(java.util.Optional.ofNullable(buildBackend()).orElse(new IngressBackendBuilder().build()));
  }
  public BackendNested<A> editOrNewBackendLike(IngressBackend item) {
    return withNewBackendLike(java.util.Optional.ofNullable(buildBackend()).orElse(item));
  }
  public String getPath() {
    return this.path;
  }
  public A withPath(String path) {
    this.path=path; return (A) this;
  }
  public boolean hasPath() {
    return this.path != null;
  }
  public String getPathType() {
    return this.pathType;
  }
  public A withPathType(String pathType) {
    this.pathType=pathType; return (A) this;
  }
  public boolean hasPathType() {
    return this.pathType != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPIngressPathFluent that = (HTTPIngressPathFluent) o;
    if (!java.util.Objects.equals(backend, that.backend)) return false;

    if (!java.util.Objects.equals(path, that.path)) return false;

    if (!java.util.Objects.equals(pathType, that.pathType)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(backend,  path,  pathType,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (backend != null) { sb.append("backend:"); sb.append(backend + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (pathType != null) { sb.append("pathType:"); sb.append(pathType + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BackendNested<N> extends IngressBackendFluent<BackendNested<N>> implements Nested<N>{
    BackendNested(IngressBackend item) {
      this.builder = new IngressBackendBuilder(this, item);
    }
    IngressBackendBuilder builder;
    public N and() {
      return (N) HTTPIngressPathFluent.this.withBackend(builder.build());
    }
    public N endBackend() {
      return and();
    }
    
  }
  
}