package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressClassBuilder extends IngressClassFluentImpl<IngressClassBuilder> implements VisitableBuilder<IngressClass,IngressClassBuilder>{
  public IngressClassBuilder() {
    this(false);
  }
  public IngressClassBuilder(Boolean validationEnabled) {
    this(new IngressClass(), validationEnabled);
  }
  public IngressClassBuilder(IngressClassFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressClassBuilder(IngressClassFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressClass(), validationEnabled);
  }
  public IngressClassBuilder(IngressClassFluent<?> fluent,IngressClass instance) {
    this(fluent, instance, false);
  }
  public IngressClassBuilder(IngressClassFluent<?> fluent,IngressClass instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressClassBuilder(IngressClass instance) {
    this(instance,false);
  }
  public IngressClassBuilder(IngressClass instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressClassFluent<?> fluent;
  Boolean validationEnabled;
  public IngressClass build() {
    IngressClass buildable = new IngressClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}