package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterCIDRSpecBuilder extends ClusterCIDRSpecFluentImpl<ClusterCIDRSpecBuilder> implements VisitableBuilder<ClusterCIDRSpec,ClusterCIDRSpecBuilder>{
  public ClusterCIDRSpecBuilder() {
    this(false);
  }
  public ClusterCIDRSpecBuilder(Boolean validationEnabled) {
    this(new ClusterCIDRSpec(), validationEnabled);
  }
  public ClusterCIDRSpecBuilder(ClusterCIDRSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterCIDRSpecBuilder(ClusterCIDRSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterCIDRSpec(), validationEnabled);
  }
  public ClusterCIDRSpecBuilder(ClusterCIDRSpecFluent<?> fluent,ClusterCIDRSpec instance) {
    this(fluent, instance, false);
  }
  public ClusterCIDRSpecBuilder(ClusterCIDRSpecFluent<?> fluent,ClusterCIDRSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIpv4(instance.getIpv4()); 
    fluent.withIpv6(instance.getIpv6()); 
    fluent.withNodeSelector(instance.getNodeSelector()); 
    fluent.withPerNodeHostBits(instance.getPerNodeHostBits()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterCIDRSpecBuilder(ClusterCIDRSpec instance) {
    this(instance,false);
  }
  public ClusterCIDRSpecBuilder(ClusterCIDRSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withIpv4(instance.getIpv4()); 
    this.withIpv6(instance.getIpv6()); 
    this.withNodeSelector(instance.getNodeSelector()); 
    this.withPerNodeHostBits(instance.getPerNodeHostBits()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterCIDRSpecFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterCIDRSpec build() {
    ClusterCIDRSpec buildable = new ClusterCIDRSpec(fluent.getIpv4(),fluent.getIpv6(),fluent.getNodeSelector(),fluent.getPerNodeHostBits());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}