package io.fabric8.kubernetes.api.model.networking.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterCIDRBuilder extends ClusterCIDRFluentImpl<ClusterCIDRBuilder> implements VisitableBuilder<ClusterCIDR,ClusterCIDRBuilder>{
  public ClusterCIDRBuilder() {
    this(false);
  }
  public ClusterCIDRBuilder(Boolean validationEnabled) {
    this(new ClusterCIDR(), validationEnabled);
  }
  public ClusterCIDRBuilder(ClusterCIDRFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterCIDRBuilder(ClusterCIDRFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterCIDR(), validationEnabled);
  }
  public ClusterCIDRBuilder(ClusterCIDRFluent<?> fluent,ClusterCIDR instance) {
    this(fluent, instance, false);
  }
  public ClusterCIDRBuilder(ClusterCIDRFluent<?> fluent,ClusterCIDR instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ClusterCIDRBuilder(ClusterCIDR instance) {
    this(instance,false);
  }
  public ClusterCIDRBuilder(ClusterCIDR instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ClusterCIDRFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterCIDR build() {
    ClusterCIDR buildable = new ClusterCIDR(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}