package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface NetworkPolicyFluent<A extends NetworkPolicyFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public NetworkPolicyFluent.MetadataNested<A> withNewMetadata();
  public NetworkPolicyFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public NetworkPolicyFluent.MetadataNested<A> editMetadata();
  public NetworkPolicyFluent.MetadataNested<A> editOrNewMetadata();
  public NetworkPolicyFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkPolicySpec getSpec();
  public NetworkPolicySpec buildSpec();
  public A withSpec(NetworkPolicySpec spec);
  public Boolean hasSpec();
  public NetworkPolicyFluent.SpecNested<A> withNewSpec();
  public NetworkPolicyFluent.SpecNested<A> withNewSpecLike(NetworkPolicySpec item);
  public NetworkPolicyFluent.SpecNested<A> editSpec();
  public NetworkPolicyFluent.SpecNested<A> editOrNewSpec();
  public NetworkPolicyFluent.SpecNested<A> editOrNewSpecLike(NetworkPolicySpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public NetworkPolicyStatus getStatus();
  public NetworkPolicyStatus buildStatus();
  public A withStatus(NetworkPolicyStatus status);
  public Boolean hasStatus();
  public NetworkPolicyFluent.StatusNested<A> withNewStatus();
  public NetworkPolicyFluent.StatusNested<A> withNewStatusLike(NetworkPolicyStatus item);
  public NetworkPolicyFluent.StatusNested<A> editStatus();
  public NetworkPolicyFluent.StatusNested<A> editOrNewStatus();
  public NetworkPolicyFluent.StatusNested<A> editOrNewStatusLike(NetworkPolicyStatus item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<NetworkPolicyFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,NetworkPolicySpecFluent<NetworkPolicyFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,NetworkPolicyStatusFluent<NetworkPolicyFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}