package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressStatusBuilder extends IngressStatusFluentImpl<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,IngressStatusBuilder>{
  public IngressStatusBuilder() {
    this(false);
  }
  public IngressStatusBuilder(Boolean validationEnabled) {
    this(new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressStatus(), validationEnabled);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance) {
    this(fluent, instance, false);
  }
  public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLoadBalancer(instance.getLoadBalancer()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressStatusBuilder(IngressStatus instance) {
    this(instance,false);
  }
  public IngressStatusBuilder(IngressStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressStatusFluent<?> fluent;
  Boolean validationEnabled;
  public IngressStatus build() {
    IngressStatus buildable = new IngressStatus(fluent.getLoadBalancer());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}