package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressServiceBackendBuilder extends IngressServiceBackendFluentImpl<IngressServiceBackendBuilder> implements VisitableBuilder<IngressServiceBackend,IngressServiceBackendBuilder>{
  public IngressServiceBackendBuilder() {
    this(false);
  }
  public IngressServiceBackendBuilder(Boolean validationEnabled) {
    this(new IngressServiceBackend(), validationEnabled);
  }
  public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IngressServiceBackend(), validationEnabled);
  }
  public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent,IngressServiceBackend instance) {
    this(fluent, instance, false);
  }
  public IngressServiceBackendBuilder(IngressServiceBackendFluent<?> fluent,IngressServiceBackend instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressServiceBackendBuilder(IngressServiceBackend instance) {
    this(instance,false);
  }
  public IngressServiceBackendBuilder(IngressServiceBackend instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  IngressServiceBackendFluent<?> fluent;
  Boolean validationEnabled;
  public IngressServiceBackend build() {
    IngressServiceBackend buildable = new IngressServiceBackend(fluent.getName(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}