package io.fabric8.kubernetes.api.model.networking.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class IngressClassSpecFluentImpl<A extends IngressClassSpecFluent<A>> extends BaseFluent<A> implements IngressClassSpecFluent<A>{
  public IngressClassSpecFluentImpl() {
  }
  public IngressClassSpecFluentImpl(IngressClassSpec instance) {
    this.withController(instance.getController()); 
    this.withParameters(instance.getParameters()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String controller;
  private IngressClassParametersReferenceBuilder parameters;
  private Map<String,Object> additionalProperties;
  public String getController() {
    return this.controller;
  }
  public A withController(String controller) {
    this.controller=controller; return (A) this;
  }
  public Boolean hasController() {
    return this.controller != null;
  }
  
  /**
   * This method has been deprecated, please use method buildParameters instead.
   * @return The buildable object.
   */
  @Deprecated
  public IngressClassParametersReference getParameters() {
    return this.parameters!=null ?this.parameters.build():null;
  }
  public IngressClassParametersReference buildParameters() {
    return this.parameters!=null ?this.parameters.build():null;
  }
  public A withParameters(IngressClassParametersReference parameters) {
    _visitables.get("parameters").remove(this.parameters);
    if (parameters!=null){ this.parameters= new IngressClassParametersReferenceBuilder(parameters); _visitables.get("parameters").add(this.parameters);} else { this.parameters = null; _visitables.get("parameters").remove(this.parameters); } return (A) this;
  }
  public Boolean hasParameters() {
    return this.parameters != null;
  }
  public A withNewParameters(String apiGroup,String kind,String name,String namespace,String scope) {
    return (A)withParameters(new IngressClassParametersReference(apiGroup, kind, name, namespace, scope));
  }
  public IngressClassSpecFluent.ParametersNested<A> withNewParameters() {
    return new IngressClassSpecFluentImpl.ParametersNestedImpl();
  }
  public IngressClassSpecFluent.ParametersNested<A> withNewParametersLike(IngressClassParametersReference item) {
    return new IngressClassSpecFluentImpl.ParametersNestedImpl(item);
  }
  public IngressClassSpecFluent.ParametersNested<A> editParameters() {
    return withNewParametersLike(getParameters());
  }
  public IngressClassSpecFluent.ParametersNested<A> editOrNewParameters() {
    return withNewParametersLike(getParameters() != null ? getParameters(): new IngressClassParametersReferenceBuilder().build());
  }
  public IngressClassSpecFluent.ParametersNested<A> editOrNewParametersLike(IngressClassParametersReference item) {
    return withNewParametersLike(getParameters() != null ? getParameters(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    IngressClassSpecFluentImpl that = (IngressClassSpecFluentImpl) o;
    if (controller != null ? !controller.equals(that.controller) :that.controller != null) return false;
    if (parameters != null ? !parameters.equals(that.parameters) :that.parameters != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(controller,  parameters,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (controller != null) { sb.append("controller:"); sb.append(controller + ","); }
    if (parameters != null) { sb.append("parameters:"); sb.append(parameters + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ParametersNestedImpl<N> extends IngressClassParametersReferenceFluentImpl<IngressClassSpecFluent.ParametersNested<N>> implements IngressClassSpecFluent.ParametersNested<N>,Nested<N>{
    ParametersNestedImpl(IngressClassParametersReference item) {
      this.builder = new IngressClassParametersReferenceBuilder(this, item);
    }
    ParametersNestedImpl() {
      this.builder = new IngressClassParametersReferenceBuilder(this);
    }
    IngressClassParametersReferenceBuilder builder;
    public N and() {
      return (N) IngressClassSpecFluentImpl.this.withParameters(builder.build());
    }
    public N endParameters() {
      return and();
    }
    
  }
  
}