package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressTLSBuilder extends IngressTLSFluentImpl<IngressTLSBuilder> implements VisitableBuilder<IngressTLS,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSBuilder>{
  public IngressTLSBuilder() {
    this(false);
  }
  public IngressTLSBuilder(Boolean validationEnabled) {
    this(new IngressTLS(), validationEnabled);
  }
  public IngressTLSBuilder(IngressTLSFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressTLS(), validationEnabled);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance) {
    this(fluent, instance, false);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHosts(instance.getHosts()); 
    fluent.withSecretName(instance.getSecretName()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance) {
    this(instance,false);
  }
  public IngressTLSBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHosts(instance.getHosts()); 
    this.withSecretName(instance.getSecretName()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLSFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressTLS build() {
    IngressTLS buildable = new IngressTLS(fluent.getHosts(),fluent.getSecretName());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}