package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressSpecBuilder extends IngressSpecFluentImpl<IngressSpecBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecBuilder>{
  public IngressSpecBuilder() {
    this(false);
  }
  public IngressSpecBuilder(Boolean validationEnabled) {
    this(new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(IngressSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressSpec(), validationEnabled);
  }
  public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec instance) {
    this(fluent, instance, false);
  }
  public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withBackend(instance.getBackend()); 
    fluent.withIngressClassName(instance.getIngressClassName()); 
    fluent.withRules(instance.getRules()); 
    fluent.withTls(instance.getTls()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec instance) {
    this(instance,false);
  }
  public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withBackend(instance.getBackend()); 
    this.withIngressClassName(instance.getIngressClassName()); 
    this.withRules(instance.getRules()); 
    this.withTls(instance.getTls()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressSpec build() {
    IngressSpec buildable = new IngressSpec(fluent.getBackend(),fluent.getIngressClassName(),fluent.getRules(),fluent.getTls());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}