package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressRuleBuilder extends IngressRuleFluentImpl<IngressRuleBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleBuilder>{
  public IngressRuleBuilder() {
    this(false);
  }
  public IngressRuleBuilder(Boolean validationEnabled) {
    this(new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(IngressRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressRule(), validationEnabled);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance) {
    this(fluent, instance, false);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHost(instance.getHost()); 
    fluent.withHttp(instance.getHttp()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance) {
    this(instance,false);
  }
  public IngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withHost(instance.getHost()); 
    this.withHttp(instance.getHttp()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressRule build() {
    IngressRule buildable = new IngressRule(fluent.getHost(),fluent.getHttp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}