package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressListBuilder extends IngressListFluentImpl<IngressListBuilder> implements VisitableBuilder<IngressList,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressListBuilder>{
  public IngressListBuilder() {
    this(false);
  }
  public IngressListBuilder(Boolean validationEnabled) {
    this(new IngressList(), validationEnabled);
  }
  public IngressListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressListFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressList(), validationEnabled);
  }
  public IngressListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList instance) {
    this(fluent, instance, false);
  }
  public IngressListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList instance) {
    this(instance,false);
  }
  public IngressListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1beta1.IngressListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressList build() {
    IngressList buildable = new IngressList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}