package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressClassListBuilder extends IngressClassListFluentImpl<IngressClassListBuilder> implements VisitableBuilder<IngressClassList,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassListBuilder>{
  public IngressClassListBuilder() {
    this(false);
  }
  public IngressClassListBuilder(Boolean validationEnabled) {
    this(new IngressClassList(), validationEnabled);
  }
  public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassListFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressClassList(), validationEnabled);
  }
  public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList instance) {
    this(fluent, instance, false);
  }
  public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassListFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList instance) {
    this(instance,false);
  }
  public IngressClassListBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassList build() {
    IngressClassList buildable = new IngressClassList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}