package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressBuilder extends IngressFluentImpl<IngressBuilder> implements VisitableBuilder<Ingress,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBuilder>{
  public IngressBuilder() {
    this(false);
  }
  public IngressBuilder(Boolean validationEnabled) {
    this(new Ingress(), validationEnabled);
  }
  public IngressBuilder(IngressFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Ingress(), validationEnabled);
  }
  public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance) {
    this(fluent, instance, false);
  }
  public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance) {
    this(instance,false);
  }
  public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress build() {
    Ingress buildable = new Ingress(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}