package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceBackendPortBuilder extends ServiceBackendPortFluentImpl<ServiceBackendPortBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort,io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortBuilder>{
  public ServiceBackendPortBuilder() {
    this(false);
  }
  public ServiceBackendPortBuilder(Boolean validationEnabled) {
    this(new ServiceBackendPort(), validationEnabled);
  }
  public ServiceBackendPortBuilder(ServiceBackendPortFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceBackendPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ServiceBackendPort(), validationEnabled);
  }
  public ServiceBackendPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort instance) {
    this(fluent, instance, false);
  }
  public ServiceBackendPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withNumber(instance.getNumber()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ServiceBackendPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort instance) {
    this(instance,false);
  }
  public ServiceBackendPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withNumber(instance.getNumber()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPortFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.ServiceBackendPort build() {
    ServiceBackendPort buildable = new ServiceBackendPort(fluent.getName(),fluent.getNumber());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}