package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class NetworkPolicyPortBuilder extends NetworkPolicyPortFluentImpl<NetworkPolicyPortBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder>{
  public NetworkPolicyPortBuilder() {
    this(false);
  }
  public NetworkPolicyPortBuilder(Boolean validationEnabled) {
    this(new NetworkPolicyPort(), validationEnabled);
  }
  public NetworkPolicyPortBuilder(NetworkPolicyPortFluent<?> fluent) {
    this(fluent, false);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new NetworkPolicyPort(), validationEnabled);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance) {
    this(fluent, instance, false);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEndPort(instance.getEndPort()); 
    fluent.withPort(instance.getPort()); 
    fluent.withProtocol(instance.getProtocol()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance) {
    this(instance,false);
  }
  public NetworkPolicyPortBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withEndPort(instance.getEndPort()); 
    this.withPort(instance.getPort()); 
    this.withProtocol(instance.getProtocol()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort build() {
    NetworkPolicyPort buildable = new NetworkPolicyPort(fluent.getEndPort(),fluent.getPort(),fluent.getProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}