package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class NetworkPolicyEgressRuleFluentImpl<A extends NetworkPolicyEgressRuleFluent<A>> extends BaseFluent<A> implements NetworkPolicyEgressRuleFluent<A>{
  public NetworkPolicyEgressRuleFluentImpl() {
  }
  public NetworkPolicyEgressRuleFluentImpl(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRule instance) {
    this.withPorts(instance.getPorts()); 
    this.withTo(instance.getTo()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<NetworkPolicyPortBuilder> ports = new java.util.ArrayList<NetworkPolicyPortBuilder>();
  private java.util.ArrayList<NetworkPolicyPeerBuilder> to = new java.util.ArrayList<NetworkPolicyPeerBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToPorts(Integer index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder>();}
    io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(java.lang.Integer index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder>();}
    io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort... items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder>();}
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort> items) {
    if (this.ports == null) {this.ports = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder>();}
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort... items) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(java.util.Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort> items) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort> getPorts() {
    return ports != null ? build(ports) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort buildPort(java.lang.Integer index) {
    return this.ports.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort buildFirstPort() {
    return this.ports.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort buildMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public java.lang.Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPort() {
    return new NetworkPolicyEgressRuleFluentImpl.PortsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.PortsNested<A> addNewPortLike(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item) {
    return new NetworkPolicyEgressRuleFluentImpl.PortsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.PortsNested<A> setNewPortLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item) {
    return new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluentImpl.PortsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.PortsNested<A> editPort(java.lang.Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.PortsNested<A> editMatchingPort(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public A addToTo(java.lang.Integer index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item) {
    if (this.to == null) {this.to = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder>();}
    io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder(item);_visitables.get("to").add(index >= 0 ? index : _visitables.get("to").size(), builder);this.to.add(index >= 0 ? index : to.size(), builder); return (A)this;
  }
  public A setToTo(java.lang.Integer index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item) {
    if (this.to == null) {this.to = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder>();}
    io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder(item);
    if (index < 0 || index >= _visitables.get("to").size()) { _visitables.get("to").add(builder); } else { _visitables.get("to").set(index, builder);}
    if (index < 0 || index >= to.size()) { to.add(builder); } else { to.set(index, builder);}
     return (A)this;
  }
  public A addToTo(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
    if (this.to == null) {this.to = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder>();}
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
  }
  public A addAllToTo(java.util.Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> items) {
    if (this.to == null) {this.to = new java.util.ArrayList<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder>();}
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder(item);_visitables.get("to").add(builder);this.to.add(builder);} return (A)this;
  }
  public A removeFromTo(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... items) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
  }
  public A removeAllFromTo(java.util.Collection<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> items) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : items) {io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder(item);_visitables.get("to").remove(builder);if (this.to != null) {this.to.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromTo(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder> predicate) {
    if (to == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder> each = to.iterator();
    final List visitables = _visitables.get("to");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildTo instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> getTo() {
    return to != null ? build(to) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> buildTo() {
    return to != null ? build(to) : null;
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer buildTo(java.lang.Integer index) {
    return this.to.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer buildFirstTo() {
    return this.to.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer buildLastTo() {
    return this.to.get(to.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer buildMatchingTo(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder item: to) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingTo(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder item: to) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withTo(java.util.List<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer> to) {
    if (this.to != null) { _visitables.get("to").removeAll(this.to);}
    if (to != null) {this.to = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item : to){this.addToTo(item);}} else { this.to = null;} return (A) this;
  }
  public A withTo(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer... to) {
    if (this.to != null) {this.to.clear();}
    if (to != null) {for (io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item :to){ this.addToTo(item);}} return (A) this;
  }
  public java.lang.Boolean hasTo() {
    return to != null && !to.isEmpty();
  }
  public NetworkPolicyEgressRuleFluent.ToNested<A> addNewTo() {
    return new NetworkPolicyEgressRuleFluentImpl.ToNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.ToNested<A> addNewToLike(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item) {
    return new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluentImpl.ToNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.ToNested<A> setNewToLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer item) {
    return new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluentImpl.ToNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.ToNested<A> editTo(java.lang.Integer index) {
    if (to.size() <= index) throw new RuntimeException("Can't edit to. Index exceeds size.");
    return setNewToLike(index, buildTo(index));
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.ToNested<A> editFirstTo() {
    if (to.size() == 0) throw new RuntimeException("Can't edit first to. The list is empty.");
    return setNewToLike(0, buildTo(0));
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.ToNested<A> editLastTo() {
    int index = to.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last to. The list is empty.");
    return setNewToLike(index, buildTo(index));
  }
  public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.ToNested<A> editMatchingTo(java.util.function.Predicate<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<to.size();i++) { 
    if (predicate.test(to.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching to. No match found.");
    return setNewToLike(index, buildTo(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetworkPolicyEgressRuleFluentImpl that = (NetworkPolicyEgressRuleFluentImpl) o;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (to != null ? !to.equals(that.to) :that.to != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(ports,  to,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (to != null && !to.isEmpty()) { sb.append("to:"); sb.append(to + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PortsNestedImpl<N> extends NetworkPolicyPortFluentImpl<NetworkPolicyEgressRuleFluent.PortsNested<N>> implements io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.PortsNested<N>,Nested<N>{
    PortsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPort item) {
      this.index = index;
      this.builder = new NetworkPolicyPortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder(this);
    }
    io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPortBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkPolicyEgressRuleFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class ToNestedImpl<N> extends NetworkPolicyPeerFluentImpl<NetworkPolicyEgressRuleFluent.ToNested<N>> implements io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent.ToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ToNestedImpl(java.lang.Integer index,NetworkPolicyPeer item) {
      this.index = index;
      this.builder = new NetworkPolicyPeerBuilder(this, item);
    }
    ToNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder(this);
    }
    io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) NetworkPolicyEgressRuleFluentImpl.this.setToTo(index,builder.build());
    }
    public N endTo() {
      return and();
    }
    
  }
  
}