package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressServiceBackendBuilder extends IngressServiceBackendFluentImpl<IngressServiceBackendBuilder> implements VisitableBuilder<IngressServiceBackend,io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder>{
  public IngressServiceBackendBuilder() {
    this(false);
  }
  public IngressServiceBackendBuilder(Boolean validationEnabled) {
    this(new IngressServiceBackend(), validationEnabled);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressServiceBackend(), validationEnabled);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance) {
    this(fluent, instance, false);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withPort(instance.getPort()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance) {
    this(instance,false);
  }
  public IngressServiceBackendBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend build() {
    IngressServiceBackend buildable = new IngressServiceBackend(fluent.getName(),fluent.getPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}