package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressClassSpecBuilder extends IngressClassSpecFluentImpl<IngressClassSpecBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpec,io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpecBuilder>{
  public IngressClassSpecBuilder() {
    this(false);
  }
  public IngressClassSpecBuilder(Boolean validationEnabled) {
    this(new IngressClassSpec(), validationEnabled);
  }
  public IngressClassSpecBuilder(IngressClassSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressClassSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressClassSpec(), validationEnabled);
  }
  public IngressClassSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpec instance) {
    this(fluent, instance, false);
  }
  public IngressClassSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withController(instance.getController()); 
    fluent.withParameters(instance.getParameters()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressClassSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpec instance) {
    this(instance,false);
  }
  public IngressClassSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withController(instance.getController()); 
    this.withParameters(instance.getParameters()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.IngressClassSpec build() {
    IngressClassSpec buildable = new IngressClassSpec(fluent.getController(),fluent.getParameters());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}