package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IngressClassBuilder extends IngressClassFluentImpl<IngressClassBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.IngressClass,io.fabric8.kubernetes.api.model.networking.v1.IngressClassBuilder>{
  public IngressClassBuilder() {
    this(false);
  }
  public IngressClassBuilder(Boolean validationEnabled) {
    this(new IngressClass(), validationEnabled);
  }
  public IngressClassBuilder(IngressClassFluent<?> fluent) {
    this(fluent, false);
  }
  public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new IngressClass(), validationEnabled);
  }
  public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressClass instance) {
    this(fluent, instance, false);
  }
  public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClassFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressClass instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClass instance) {
    this(instance,false);
  }
  public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressClass instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.networking.v1.IngressClassFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.networking.v1.IngressClass build() {
    IngressClass buildable = new IngressClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}