/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRule;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluent;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyEgressRuleFluentImpl;
import java.util.Objects;

public class NetworkPolicyEgressRuleBuilder
extends NetworkPolicyEgressRuleFluentImpl<NetworkPolicyEgressRuleBuilder>
implements VisitableBuilder<NetworkPolicyEgressRule, NetworkPolicyEgressRuleBuilder> {
    NetworkPolicyEgressRuleFluent<?> fluent;
    Boolean validationEnabled;

    public NetworkPolicyEgressRuleBuilder() {
        this(false);
    }

    public NetworkPolicyEgressRuleBuilder(Boolean validationEnabled) {
        this(new NetworkPolicyEgressRule(), validationEnabled);
    }

    public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NetworkPolicyEgressRule(), validationEnabled);
    }

    public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent, NetworkPolicyEgressRule instance) {
        this(fluent, instance, false);
    }

    public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRuleFluent<?> fluent, NetworkPolicyEgressRule instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withPorts(instance.getPorts());
        fluent.withTo(instance.getTo());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRule instance) {
        this(instance, (Boolean)false);
    }

    public NetworkPolicyEgressRuleBuilder(NetworkPolicyEgressRule instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withPorts(instance.getPorts());
        this.withTo(instance.getTo());
        this.validationEnabled = validationEnabled;
    }

    public NetworkPolicyEgressRule build() {
        NetworkPolicyEgressRule buildable = new NetworkPolicyEgressRule(this.fluent.getPorts(), this.fluent.getTo());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NetworkPolicyEgressRuleBuilder that = (NetworkPolicyEgressRuleBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

