package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressSpecBuilder extends io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.IngressSpec,io.fabric8.kubernetes.api.model.networking.v1.IngressSpecBuilder> {

    io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressSpecBuilder() {
        this(true);
    }

    public IngressSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new IngressSpec(), validationEnabled);
    }

    public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new IngressSpec(), validationEnabled);
    }

    public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressSpec instance) {
        this(fluent, instance, true);
    }

    public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.IngressSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withDefaultBackend(instance.getDefaultBackend()); 
        fluent.withIngressClassName(instance.getIngressClassName()); 
        fluent.withRules(instance.getRules()); 
        fluent.withTls(instance.getTls()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressSpec instance) {
        this(instance,true);
    }

    public IngressSpecBuilder(io.fabric8.kubernetes.api.model.networking.v1.IngressSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withDefaultBackend(instance.getDefaultBackend()); 
        this.withIngressClassName(instance.getIngressClassName()); 
        this.withRules(instance.getRules()); 
        this.withTls(instance.getTls()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressSpec build() {
        IngressSpec buildable = new IngressSpec(fluent.getDefaultBackend(),fluent.getIngressClassName(),fluent.getRules(),fluent.getTls());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressSpecBuilder that = (IngressSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
