package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressBuilder extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluentImpl<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBuilder> {

    io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public IngressBuilder() {
        this(true);
    }

    public IngressBuilder(java.lang.Boolean validationEnabled) {
        this(new Ingress(), validationEnabled);
    }

    public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new Ingress(), validationEnabled);
    }

    public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance) {
        this(fluent, instance, true);
    }

    public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance) {
        this(instance,true);
    }

    public IngressBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.Ingress build() {
        Ingress buildable = new Ingress(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressBuilder that = (IngressBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
