package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NetworkPolicyIngressRuleBuilder extends io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleBuilder> {

    io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NetworkPolicyIngressRuleBuilder() {
        this(true);
    }

    public NetworkPolicyIngressRuleBuilder(java.lang.Boolean validationEnabled) {
        this(new NetworkPolicyIngressRule(), validationEnabled);
    }

    public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NetworkPolicyIngressRule(), validationEnabled);
    }

    public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule instance) {
        this(fluent, instance, true);
    }

    public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withFrom(instance.getFrom()); 
        fluent.withPorts(instance.getPorts()); 
        this.validationEnabled = validationEnabled; 
    }

    public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule instance) {
        this(instance,true);
    }

    public NetworkPolicyIngressRuleBuilder(io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withFrom(instance.getFrom()); 
        this.withPorts(instance.getPorts()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyIngressRule build() {
        NetworkPolicyIngressRule buildable = new NetworkPolicyIngressRule(fluent.getFrom(),fluent.getPorts());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NetworkPolicyIngressRuleBuilder that = (NetworkPolicyIngressRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
