package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class IngressBackendFluentImpl<A extends io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent<A> {

    private io.fabric8.kubernetes.api.model.TypedLocalObjectReference resource;
    private io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder service;

    public IngressBackendFluentImpl() {
    }

    public IngressBackendFluentImpl(io.fabric8.kubernetes.api.model.networking.v1.IngressBackend instance) {
        this.withResource(instance.getResource()); 
        this.withService(instance.getService()); 
    }

    public io.fabric8.kubernetes.api.model.TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public A withResource(io.fabric8.kubernetes.api.model.TypedLocalObjectReference resource) {
        this.resource=resource; return (A) this;
    }

    public java.lang.Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(java.lang.String apiGroup,java.lang.String kind,java.lang.String name) {
        return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildService instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend getService() {
        return this.service!=null?this.service.build():null;
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend buildService() {
        return this.service!=null?this.service.build():null;
    }

    public A withService(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend service) {
        _visitables.get("service").remove(this.service);
        if (service!=null){ this.service= new io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder(service); _visitables.get("service").add(this.service);} return (A) this;
    }

    public java.lang.Boolean hasService() {
        return this.service != null;
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> withNewService() {
        return new io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluentImpl.ServiceNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> withNewServiceLike(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend item) {
        return new io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluentImpl.ServiceNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> editService() {
        return withNewServiceLike(getService());
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> editOrNewService() {
        return withNewServiceLike(getService() != null ? getService(): new io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<A> editOrNewServiceLike(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend item) {
        return withNewServiceLike(getService() != null ? getService(): item);
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (service != null ? !service.equals(that.service) :that.service != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(resource,  service,  super.hashCode());
    }

    public class ServiceNestedImpl<N> extends io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendFluentImpl<io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<N>> implements io.fabric8.kubernetes.api.model.networking.v1.IngressBackendFluent.ServiceNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder builder;

            ServiceNestedImpl(io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackend item) {
                this.builder = new io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder(this, item);
                        
            }

            ServiceNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.networking.v1.IngressServiceBackendBuilder(this);
                        
            }

            public N and() {
                return (N) IngressBackendFluentImpl.this.withService(builder.build());
            }

            public N endService() {
                return and();
            }
    }


}
