package io.fabric8.kubernetes.api.model.networking.v1;

import java.lang.Integer;
import java.lang.StringBuffer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;

public class ServiceBackendPortFluentImpl<A extends ServiceBackendPortFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ServiceBackendPortFluent<A> {

    private String name;
    private Integer number;

    public ServiceBackendPortFluentImpl() {
    }

    public ServiceBackendPortFluentImpl(ServiceBackendPort instance) {
        this.withName(instance.getName()); 
        this.withNumber(instance.getNumber()); 
    }

    public String getName() {
        return this.name;
    }

    public A withName(String name) {
        this.name=name; return (A) this;
    }

    public Boolean hasName() {
        return this.name != null;
    }

    public A withNewName(String arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuilder arg1) {
        return (A)withName(new String(arg1));
    }

    public A withNewName(StringBuffer arg1) {
        return (A)withName(new String(arg1));
    }

    public Integer getNumber() {
        return this.number;
    }

    public A withNumber(Integer number) {
        this.number=number; return (A) this;
    }

    public Boolean hasNumber() {
        return this.number != null;
    }

    public A withNewNumber(String arg1) {
        return (A)withNumber(new Integer(arg1));
    }

    public A withNewNumber(int arg1) {
        return (A)withNumber(new Integer(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ServiceBackendPortFluentImpl that = (ServiceBackendPortFluentImpl) o;
        if (name != null ? !name.equals(that.name) :that.name != null) return false;
        if (number != null ? !number.equals(that.number) :that.number != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(name,  number,  super.hashCode());
    }

}
