package io.fabric8.kubernetes.api.model.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class IngressClassBuilder extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassFluentImpl<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassBuilder> {

    io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassFluent<?> fluent;
    Boolean validationEnabled;

    public IngressClassBuilder() {
        this(true);
    }

    public IngressClassBuilder(Boolean validationEnabled) {
        this(new IngressClass(), validationEnabled);
    }

    public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassFluent<?> fluent) {
        this(fluent, true);
    }

    public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new IngressClass(), validationEnabled);
    }

    public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass instance) {
        this(fluent, instance, true);
    }

    public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClassFluent<?> fluent,io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass instance) {
        this(instance,true);
    }

    public IngressClassBuilder(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.networking.v1beta1.IngressClass build() {
        IngressClass buildable = new IngressClass(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        IngressClassBuilder that = (IngressClassBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
