/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.networking.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.IPBlock;
import io.fabric8.kubernetes.api.model.networking.v1.IPBlockBuilder;
import io.fabric8.kubernetes.api.model.networking.v1.IPBlockFluentImpl;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeer;
import io.fabric8.kubernetes.api.model.networking.v1.NetworkPolicyPeerFluent;
import java.util.Objects;

public class NetworkPolicyPeerFluentImpl<A extends NetworkPolicyPeerFluent<A>>
extends BaseFluent<A>
implements NetworkPolicyPeerFluent<A> {
    private IPBlockBuilder ipBlock;
    private LabelSelectorBuilder namespaceSelector;
    private LabelSelectorBuilder podSelector;

    public NetworkPolicyPeerFluentImpl() {
    }

    public NetworkPolicyPeerFluentImpl(NetworkPolicyPeer instance) {
        this.withIpBlock(instance.getIpBlock());
        this.withNamespaceSelector(instance.getNamespaceSelector());
        this.withPodSelector(instance.getPodSelector());
    }

    @Override
    @Deprecated
    public IPBlock getIpBlock() {
        return this.ipBlock != null ? this.ipBlock.build() : null;
    }

    @Override
    public IPBlock buildIpBlock() {
        return this.ipBlock != null ? this.ipBlock.build() : null;
    }

    @Override
    public A withIpBlock(IPBlock ipBlock) {
        this._visitables.get((Object)"ipBlock").remove(this.ipBlock);
        if (ipBlock != null) {
            this.ipBlock = new IPBlockBuilder(ipBlock);
            this._visitables.get((Object)"ipBlock").add(this.ipBlock);
        }
        return (A)this;
    }

    @Override
    public Boolean hasIpBlock() {
        return this.ipBlock != null;
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlock() {
        return new IpBlockNestedImpl();
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> withNewIpBlockLike(IPBlock item) {
        return new IpBlockNestedImpl(item);
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> editIpBlock() {
        return this.withNewIpBlockLike(this.getIpBlock());
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlock() {
        return this.withNewIpBlockLike(this.getIpBlock() != null ? this.getIpBlock() : new IPBlockBuilder().build());
    }

    @Override
    public NetworkPolicyPeerFluent.IpBlockNested<A> editOrNewIpBlockLike(IPBlock item) {
        return this.withNewIpBlockLike(this.getIpBlock() != null ? this.getIpBlock() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(LabelSelector namespaceSelector) {
        this._visitables.get((Object)"namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
            this._visitables.get((Object)"namespaceSelector").add(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NetworkPolicyPeerFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    @Deprecated
    public LabelSelector getPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public LabelSelector buildPodSelector() {
        return this.podSelector != null ? this.podSelector.build() : null;
    }

    @Override
    public A withPodSelector(LabelSelector podSelector) {
        this._visitables.get((Object)"podSelector").remove(this.podSelector);
        if (podSelector != null) {
            this.podSelector = new LabelSelectorBuilder(podSelector);
            this._visitables.get((Object)"podSelector").add(this.podSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasPodSelector() {
        return this.podSelector != null;
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelector() {
        return new PodSelectorNestedImpl();
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> withNewPodSelectorLike(LabelSelector item) {
        return new PodSelectorNestedImpl(item);
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> editPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector());
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelector() {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : new LabelSelectorBuilder().build());
    }

    @Override
    public NetworkPolicyPeerFluent.PodSelectorNested<A> editOrNewPodSelectorLike(LabelSelector item) {
        return this.withNewPodSelectorLike(this.getPodSelector() != null ? this.getPodSelector() : item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkPolicyPeerFluentImpl that = (NetworkPolicyPeerFluentImpl)o;
        if (this.ipBlock != null ? !this.ipBlock.equals(that.ipBlock) : that.ipBlock != null) {
            return false;
        }
        if (this.namespaceSelector != null ? !this.namespaceSelector.equals((Object)that.namespaceSelector) : that.namespaceSelector != null) {
            return false;
        }
        return !(this.podSelector != null ? !this.podSelector.equals((Object)that.podSelector) : that.podSelector != null);
    }

    public int hashCode() {
        return Objects.hash(this.ipBlock, this.namespaceSelector, this.podSelector, super.hashCode());
    }

    public class PodSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.PodSelectorNested<N>>
    implements NetworkPolicyPeerFluent.PodSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        PodSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        PodSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluentImpl.this.withPodSelector(this.builder.build());
        }

        @Override
        public N endPodSelector() {
            return this.and();
        }
    }

    public class NamespaceSelectorNestedImpl<N>
    extends LabelSelectorFluentImpl<NetworkPolicyPeerFluent.NamespaceSelectorNested<N>>
    implements NetworkPolicyPeerFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        private final LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder((LabelSelectorFluent)this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    public class IpBlockNestedImpl<N>
    extends IPBlockFluentImpl<NetworkPolicyPeerFluent.IpBlockNested<N>>
    implements NetworkPolicyPeerFluent.IpBlockNested<N>,
    Nested<N> {
        private final IPBlockBuilder builder;

        IpBlockNestedImpl(IPBlock item) {
            this.builder = new IPBlockBuilder(this, item);
        }

        IpBlockNestedImpl() {
            this.builder = new IPBlockBuilder(this);
        }

        @Override
        public N and() {
            return (N)NetworkPolicyPeerFluentImpl.this.withIpBlock(this.builder.build());
        }

        @Override
        public N endIpBlock() {
            return this.and();
        }
    }
}

