package io.fabric8.kubernetes.api.model.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.TypedLocalObjectReference;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Boolean;
import com.fasterxml.jackson.core.JsonParser;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;

public class IngressBackendFluentImpl<A extends io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackendFluent<A> {

    private TypedLocalObjectReference resource;
    private String serviceName;
    private IntOrStringBuilder servicePort;

    public IngressBackendFluentImpl() { 
    }


    public IngressBackendFluentImpl(io.fabric8.kubernetes.api.model.networking.v1beta1.IngressBackend instance) { 
        this.withResource(instance.getResource()); 
        this.withServiceName(instance.getServiceName()); 
        this.withServicePort(instance.getServicePort()); 
    }


    public TypedLocalObjectReference getResource() {
        return this.resource;
    }

    public A withResource(TypedLocalObjectReference resource) {
        this.resource=resource; return (A) this;
    }

    public Boolean hasResource() {
        return this.resource != null;
    }

    public A withNewResource(String apiGroup,String kind,String name) {
        return (A)withResource(new TypedLocalObjectReference(apiGroup, kind, name));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public A withServiceName(String serviceName) {
        this.serviceName=serviceName; return (A) this;
    }

    public Boolean hasServiceName() {
        return this.serviceName != null;
    }

    public A withNewServiceName(String arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuilder arg1) {
        return (A)withServiceName(new String(arg1));
    }

    public A withNewServiceName(StringBuffer arg1) {
        return (A)withServiceName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildServicePort instead.
 * @return The buildable object.
 */
@Deprecated public IntOrString getServicePort() {
        return this.servicePort!=null?this.servicePort.build():null;
    }

    public IntOrString buildServicePort() {
        return this.servicePort!=null?this.servicePort.build():null;
    }

    public A withServicePort(IntOrString servicePort) {
        _visitables.get("servicePort").remove(this.servicePort);
        if (servicePort!=null){ this.servicePort= new IntOrStringBuilder(servicePort); _visitables.get("servicePort").add(this.servicePort);} return (A) this;
    }

    public Boolean hasServicePort() {
        return this.servicePort != null;
    }

    public A withNewServicePort(String strVal) {
        return (A)withServicePort(new IntOrString(strVal));
    }

    public A withNewServicePort(Integer intVal) {
        return (A)withServicePort(new IntOrString(intVal));
    }

    public IngressBackendFluent.ServicePortNested<A> withNewServicePort() {
        return new ServicePortNestedImpl();
    }

    public IngressBackendFluent.ServicePortNested<A> withNewServicePortLike(IntOrString item) {
        return new ServicePortNestedImpl(item);
    }

    public IngressBackendFluent.ServicePortNested<A> editServicePort() {
        return withNewServicePortLike(getServicePort());
    }

    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePort() {
        return withNewServicePortLike(getServicePort() != null ? getServicePort(): new IntOrStringBuilder().build());
    }

    public IngressBackendFluent.ServicePortNested<A> editOrNewServicePortLike(IntOrString item) {
        return withNewServicePortLike(getServicePort() != null ? getServicePort(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
        if (resource != null ? !resource.equals(that.resource) :that.resource != null) return false;
        if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
        if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(resource,  serviceName,  servicePort,  super.hashCode());
    }

    public class ServicePortNestedImpl<N> extends IntOrStringFluentImpl<IngressBackendFluent.ServicePortNested<N>> implements IngressBackendFluent.ServicePortNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final IntOrStringBuilder builder;

        ServicePortNestedImpl(IntOrString item) {
            this.builder = new IntOrStringBuilder(this, item);
        }

        ServicePortNestedImpl() {
            this.builder = new IntOrStringBuilder(this);
        }

        public N and() {
             return (N) IngressBackendFluentImpl.this.withServicePort(builder.build());
        }

        public N endServicePort() {
             return and();
        }
    }


}
